<?php

namespace App\Enums;

enum FeedbackType: int
{
    case TEXT  = 0;
    case AUDIO = 1;
    case IMAGE = 2;


      /**
     * Get all the possible values as an array
     */
    public static function values(): array
    {
        return [
            self::TEXT->value,
            self::AUDIO->value,
            self::IMAGE->value,
        ];
    }

      /**
     * Get available feedback type
     */
    public static function feedbackType(self $type): string
    {
        return match($type) {
            self::TEXT  => 'text',
            self::AUDIO => 'audio',
            self::IMAGE => 'image',
        };
    }
}