<?php

namespace App\Enums;

enum PaymentStatus: int
{
    case PENDING     = 0;
    case PAID        = 1;
    case IN_PROGRESS = 2;
    case CANCELED    = 3;

    public static function default(): self
    {
        return self::PENDING;
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public static function paymentStatus(self $type): string
    {
        return match($type) {
            self::PENDING     => __('main.attributes.pending'),
            self::PAID        => __('main.attributes.paid'),
            self::IN_PROGRESS => __('main.attributes.in_progress'),
            self::CANCELED    => __('main.attributes.canceled'),
        };
    }

    public static function getKeyValuePairs(): array
    {
        return array_map(fn ($status) => [
            'key'   => self::paymentStatus($status),
            'value' => $status->value,
        ], self::cases());
    }
}
