<?php

namespace App\Enums;

enum QuestionType: int
{
    case Listening = 0;
    case Reading   = 1;
    case Writing   = 2;
    case Case      = 3;
    public static function values(): array
    {
        return [
            self::Listening->value,
            self::Reading->value,
            self::Writing->value,
            self::Case->value,
        ];
    }

    public static function questionCategory(self $type): string
    {
        return match($type) {
            self::Listening => 'listening',
            self::Reading   => 'reading',
            self::Writing   => 'writing',
            self::Case      => 'case',
        };
    }

    public static function getKeyValuePairs(): array
    {
        return [
            [
                'value' => self::Listening->value,
                'key'   => 'Listening',
            ],
            [
                'value' => self::Reading->value,
                'key'   => 'Reading',
            ],
            [
                'value' => self::Writing->value,
                'key'   => 'Writing',
            ],
            [
                'value' => self::Case->value,
                'key'   => 'Case',
            ],
        ];
    }
}
