<?php

namespace App\Enums;

enum TicketPriority: int
{
    case LOW = 0;
    case MEDIUM = 1;
    case HIGH = 2;
    case URGENT = 3;

    public function label(): string
    {
        return ucfirst(strtolower($this->name));
    }

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }
}

