<?php

namespace App\Enums;

enum TicketStatus: int
{
    case NEW = 0;
    case PENDING = 1;
    case IN_PROGRESS = 2;
    case CLOSED = 3;

    /**
     * Get all the possible values as an array
     */
    public static function values(): array
    {
        return [
            self::NEW->value,
            self::PENDING->value,
            self::IN_PROGRESS->value,
            self::CLOSED->value,
        ];
    }

    /**
     * Get available ticket status
     */
    public static function ticketStatus(self $status): string
    {
        return match($status) {
            self::NEW => 'new',
            self::PENDING => 'pending',
            self::IN_PROGRESS => 'in_progress',
            self::CLOSED => 'closed',
        };
    }
}
