<?php

namespace App\Enums;

enum TicketType: int
{
    case TEXT = 0;
    case AUDIO = 1;

    /**
     * Get all the possible values as an array
     */
    public static function values(): array
    {
        return [
            self::TEXT->value,
            self::AUDIO->value,
        ];
    }

    /**
     * Get available ticket type
     */
    public static function ticketType(self $type): string
    {
        return match($type) {
            self::TEXT => 'text',
            self::AUDIO => 'audio',
        };
    }
}