<?php

namespace App\Enums;

enum TypeCoupon: int
{
    case DISCOUNT = 0;
    case FIXED = 1;

    public static function values(): array
    {
        return [
            self::DISCOUNT->value,
            self::FIXED->value,
        ];
    }
    public static function label(self $type): string
    {
        return match ($type) {
            self::DISCOUNT => 'Discount',
            self::FIXED => 'Fixed Amount',
        };
    }
}
