<?php

namespace App\Enums;

enum UserType: int
{
    case STUDENT    = 0;
    case ADMIN      = 1;
    case SUPERVISOR = 2;
    case INSTRUCTOR = 3;

      /**
     * Get all the possible values as an array
     */
    public static function values(): array
    {
        return [
            self::STUDENT->value,
            self::ADMIN->value,
            self::SUPERVISOR->value,
            self::INSTRUCTOR->value,
        ];
    }

      /**
     * Get available user type
     */
    public static function userType(self $type): string
    {
        return match($type) {
            self::STUDENT    => 'student',
            self::ADMIN      => 'admin',
            self::SUPERVISOR => 'supervisor',
            self::INSTRUCTOR => 'instructor',
        };
    }

      /**
     * Converts an integer user type to its string representation.
     *
     * @param int $type Integer value of the user type (0, 1, 2, 3).
     * @return string String representation of the user type ('student', 'admin', 'supervisor', 'instructor').
     */
    public static function userTypeFromInt(int $type): string
    {
        return self::userType(self::from($type));
    }

    public static function getKeyValuePairs(): array
    {
        return [
            [
                'value' => self::STUDENT->value,
                'key'   => __('main.attributes.student'),
            ],
            [
                'value' => self::ADMIN->value,
                'key'   => __('main.attributes.admin'),
            ],
            [
                'value' => self::SUPERVISOR->value,
                'key'   => __('main.attributes.supervisor'),
            ],
            [
                'value' => self::INSTRUCTOR->value,
                'key'   => __('main.attributes.instructor'),
            ],
        ];
    }
}