<?php

namespace App\Exports;

use App\Models\RoundStudent;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class UsersExport implements FromCollection, WithHeadings
{
    private $student_ids;
    private $round_id;

    public function __construct($student_ids, $round_id)
    {
        $this->student_ids = $student_ids;
        $this->round_id = $round_id;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        $userIds = $this->student_ids ?? [];

        if ($this->round_id !== null) {
            $roundUserIds = RoundStudent::where('round_id', $this->round_id)
                ->pluck('user_id')
                ->toArray();

            $userIds = !empty($this->student_ids)
                ? array_intersect($this->student_ids, $roundUserIds)
                : $roundUserIds;
        }

        $userIds = is_array($userIds) ? $userIds : [];

        return User::whereIn('id', $userIds)
            ->select('id', 'name', 'email', 'phone', 'created_at')
            ->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return ['ID', 'Name', 'Email', 'Phone', 'Created At'];
    }
}
