<?php

namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class ActivityLogFilters extends QueryFilters
{
    protected array $allowedFilters = [];

    protected array $columnSearch = [];
    protected $searchable = [
        'action',
        'message',
        'user.name',
        'user.email',
    ];

    protected $sortable = [
        'created_at',
        'action',
    ];

    public function search($value)
    {
        $this->builder->where(function ($query) use ($value) {
            foreach ($this->searchable as $column) {
                if (str_contains($column, '.')) {
                    $this->filterByRelationship($query, $column, $value);
                } else {
                    $query->orWhere($column, 'like', "%{$value}%");
                }
            }
        });
    }

    public function action($value)
    {
        $this->builder->where('action', $value);
    }

    public function user_name($value)
    {
        $this->builder->whereHas('user', function ($query) use ($value) {
            $query->where('name', 'LIKE', "%{$value}%");
        });
    }

    public function date_from($value)
    {
        $this->builder->whereDate('created_at', '>=', $value);
    }

    public function date_to($value)
    {
        $this->builder->whereDate('created_at', '<=', $value);
    }

    protected function filterByRelationship($query, $column, $value)
    {
        $parts = explode('.', $column);
        $relation = $parts[0];
        $field = $parts[1];

        $query->orWhereHas($relation, function ($q) use ($field, $value) {
            $q->where($field, 'like', "%{$value}%");
        });
    }
}
