<?php

namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class CategoryFilters extends QueryFilters
{
    protected array $allowedFilters = ['status'];
    protected array $columnSearch = ['name'];

    public function course($term){
        return $this->builder->whereHas('courses', function ($query) use ($term) {
            $query->where('title', 'like', "%$term%");
        });
    }

}
