<?php

namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class InstallmentFilters extends QueryFilters
{
    protected array $allowedFilters = [
        'course_enrollment_id',
        'status',
        'due_date',
        'amount',
        'transaction_id',
        'user_id',
    ];

    protected array $columnSearch = [];
    public function from_date($term)
    {
        $this->builder->where('due_date', '>=', $term);
    }

    public function to_date($term)
    {
        $this->builder->where('due_date', '<=', $term);
    }

    public function search($term)
    {
        $this->builder->whereHas('user', function ($query) use ($term) {
            $query->where('name', 'LIKE', "%{$term}%")
                  ->orWhere('email', 'LIKE', "%{$term}%")
                  ->orWhere('phone', 'LIKE', "%{$term}%");
        });
    }
}
