<?php

namespace App\Filters;

use Essa\APIToolKit\Filters\QueryFilters;

class TaskFeedbackFilters extends QueryFilters
{
    protected array $allowedFilters = [
        'created_by',
        'created_at',
    ];

    protected array $columnSearch = [
        'note',
        'content',
    ];

    public function createdBy($id)
    {
        return $this->builder->where('created_by', $id);
    }

    public function lecture($id)
    {
        return $this->builder->whereHas('taskSubmission.lecture', function ($query) use ($id) {
            $query->where('lectures.id', $id);
        });
    }

    public function round_id($id)
    {
        return $this->builder->whereHas('taskSubmission.lecture.round', function ($query) use ($id) {
            $query->where('rounds.id', $id);
        });
    }

    public function student($name)
    {
        return $this->builder->whereHas('taskSubmission.user', function ($query) use ($name) {
            $query->where('users.name', $name);
        });
    }

    public function createdFrom($date)
    {
        return $this->builder->whereDate('created_at', '>=', $date);
    }

    public function createdTo($date)
    {
        return $this->builder->whereDate('created_at', '<=', $date);
    }
}
