<?php

namespace App\Filters;

use App\Enums\TicketStatus;
use Carbon\Carbon;
use Essa\APIToolKit\Filters\QueryFilters;

class TicketSystemFilters extends QueryFilters
{
    protected array $allowedFilters = [
        'status',
        'open_date',
        'close_date',
        'assigned_to',
        'name',
    ];

    protected array $columnSearch = [];

    public function status($term)
    {
        if (in_array($term, TicketStatus::values(), true)) {
            $this->builder->where('status', $term);
        }
    }

    public function open_date($term)
    {
        $this->builder->whereDate('open_date', Carbon::parse($term)->format('Y-m-d'));
    }

    public function close_date($term)
    {
        $this->builder->whereDate('close_date', Carbon::parse($term)->format('Y-m-d'));
    }

    public function assigned_to($term)
    {
        $this->builder->where('assigned_to', $term);
    }

    public function name($term)
    {
        $this->builder->whereHas('user', function ($query) use ($term) {
            $query->where('name', 'LIKE', "%{$term}%");
        });
    }
}
