<?php

namespace App\Filters;

use App\Models\CourseEnrollment;
use App\Models\Round;
use Essa\APIToolKit\Filters\QueryFilters;

class TransactionFilters extends QueryFilters
{
    protected array $allowedFilters = [
        'user_id',
        'type',
    ];

    protected array $columnSearch = [];

    public function round_id($term){
        $courseEnrollmentIds= CourseEnrollment::where('round_id', $term)->get()->pluck('id');
        $this->builder->whereIn('course_enrollment_id', $courseEnrollmentIds);
    }

    public function payment_date_from($term)
    {
        $this->builder->whereDate('payment_date', '>=', $term);
    }

    public function payment_date_to($term)
    {
        $this->builder->whereDate('payment_date', '<=', $term);
    }

    public function installment_due_date_from($term)
    {
        $this->builder->whereHas('installment', function ($query) use ($term) {
            $query->where('due_date', '>=', $term);
        });
    }

    public function installment_due_date_to($term)
    {
        $this->builder->whereHas('installment', function ($query) use ($term) {
            $query->where('due_date', '<=', $term);
        });
    }

    public function installment_payment_status($term)
    {
        $this->builder->whereHas('installment', function ($query) use ($term) {
            $query->where('status', $term);
        });
    }

    public function payment_method($term)
    {
        $this->builder->where('payment_method', $term);
    }

    public function search($term){
        $this->builder->whereHas('user', function ($query) use ($term) {
            $query->where('name', 'LIKE', "%{$term}%")
                  ->orWhere('email', 'LIKE', "%{$term}%")
                  ->orWhere('phone', 'LIKE', "%{$term}%");
        });
        $this->builder->orwhere('reference_code', 'LIKE', "%{$term}%");
        $this->builder->orwhere('payment_method', 'LIKE', "%{$term}%");
    }
}
