<?php

namespace App\Filters;

use App\Enums\UserType;
use Essa\APIToolKit\Filters\QueryFilters;
use Essa\APIToolKit\Traits\DateFilter;

class UserFilters extends QueryFilters
{
    use DateFilter;

    protected array $allowedFilters = ['status', 'is_open', 'last_logout_at', 'last_activity'];

    protected array $columnSearch = ['name','email','phone'];

    public function course($term)
    {
        $this->builder->whereHas('enrolledCourses', function ($query) use ($term) {
            $query->where('course_id', $term);
        });
    }

    public function is_open($term)
    {
        $value = filter_var($term, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);
        $this->builder->where('is_open', $value ?? $term);
    }

    public function last_logout_at($term)
    {
        $this->builder->whereDate('last_logout_at', $term);
    }

    public function last_activity($term)
    {
        $this->builder->whereDate('last_activity', $term);
    }
}
