<?php

namespace App\Helpers;

use App\Models\RoundStudent;
use App\Models\User;

class UserRoundStatusHelper
{
    /**
     * Get the status for a round based on the user's role.
     */
    public static function getStatusForRound(User $user): ?int
    {
        if ($user->relationLoaded('studentRounds') && $user->studentRounds->isNotEmpty()) {
            return $user->studentRounds->first()->pivot->status;
        }

        if ($user->relationLoaded('supervisorRounds') && $user->supervisorRounds->isNotEmpty()) {
            return $user->supervisorRounds->first()->pivot->status;
        }

        return null;
    }

    public static function getUserRoundStatus($resource): ?int
    {
        $user = $resource instanceof RoundStudent ? $resource->user : $resource;
        return self::getStatusForRound($user);
    }
}
