<?php

namespace App\Http\Controllers\Api\V1\Authentication;

use App\Services\AuthService;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminAuth\AdminLoginRequest;

class AuthController extends Controller
{
    public function __construct(protected AuthService $authService)
    {
        //
    }

    public function login(AdminLoginRequest $request): JsonResponse
    {
        return $this->authService->login($request->validated(), $userType='admin');
    }
    public function logout(): JsonResponse
    {
        return $this->authService->logout();
    }
}
