<?php

namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Models\ContactUs;
use App\Http\Controllers\Controller;
use App\Http\Requests\ContactUs\CreateContactUsRequest;

class ContactUsController extends Controller
{
    public function store(CreateContactUsRequest $request)
    {
        $data            = $request->validated();
        $data['user_id'] = auth()->user()->id;
        ContactUs::create($data);
        return $this->apiResponse([],__('main.contact_us_created_successfully'),201);
    }

}
