<?php
namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Resources\Topic\TopicResource;
use App\Models\Course;
use App\Http\Traits\ApiResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\Course\CourseResource;
use App\Http\Resources\LecturerLog\LecturerLogResource;
use App\Models\LecturerLog;
use App\Models\Topic;

class HomeController extends Controller
{
    use ApiResponse;

    public function __invoke(){
        // $courses = Course::latest()
        //     ->with('category:id,name')
        //     ->get();

        $topics=Topic::with(['courses' => function($query) {
                $query->with('category:id,name');
            }])->orderBy('order')->get();


        $lecturerLogsGrouped = LecturerLog::where('user_id', auth()->id())
            ->latest()
            ->get()
            ->groupBy('course_id');

        $formattedLecturerLogs = $lecturerLogsGrouped->map(function ($logsInRound, $courseId) {
            $count = $logsInRound->count();
            $lectureCount = $logsInRound->first()->course->lectures()->count();

            $percentage = $lectureCount > 0 ? ($count / $lectureCount) * 100 : 0;

            return [
                'course_id' => $courseId,
                'count' => $count,
                'Lecture_count' => $lectureCount,
                'percentage' => round($percentage, 2),
                'last_log' => $logsInRound->first(),
                'logs' => LecturerLogResource::collection($logsInRound),
            ];
        })->values();


        $data=[
            'placement_test_status'=>auth()->user()->placement_test_status,
            'topics'=> TopicResource::collection($topics),
            'lecturerLogs' => empty($formattedLecturerLogs) ? null : $formattedLecturerLogs,
        ];
        return $this->apiResponseShow($data);
    }
}
