<?php
namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Models\Course;
use App\Http\Controllers\Controller;
use App\Http\Resources\Course\CourseResource;
use App\Http\Resources\FreeMaterial\FreeMaterialResource;
use App\Http\Resources\Round\RoundResource;
use App\Http\Resources\Topic\TopicResource;
use App\Models\FreeMaterial;
use App\Models\Round;
use App\Models\Topic;

class LearningController extends Controller
{
    public function __invoke(){
        // $myCourses = Course::whereHas("enrollments",function($query){
        //     $query->where("user_id",auth()->user()->id)
        //     ->where("payment_status",1);
        // })->get();
        // $topics=Topic::whereHas('courses', function($query) {
        //     $query->whereHas('enrollments', function($q) {
        //         $q->where('user_id', auth()->id())
        //         ->where('payment_status', 1);
        //     });
        // })->with('courses')->orderBy('order')->get();
        $groups=Round::whereHas('students', function($query) {
            $query->where('user_id', auth()->id());
        })->with('course')->get();

        $freePlanMaterials = FreeMaterial::select('id', 'type', 'title', 'link')
            ->latest()
            ->get();
        return $this->apiResponseShow([
            'groups'=>RoundResource::collection($groups),
            // 'enrolled_courses'    => TopicResource::collection($topics),
            'free_plan_materials' => [
                'videos' => FreeMaterialResource::collection($freePlanMaterials->where('type', 'video')),
                'pdfs'   => FreeMaterialResource::collection($freePlanMaterials->where('type', 'pdf')),
            ],
        ]);
    }
}
