<?php
namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Enums\DefineStatus;
use App\Enums\PaymentStatus;
use App\Models\Course;
use App\Http\Controllers\Controller;
use App\Http\Resources\Course\CourseResource;
use App\Models\CourseEnrollment;
use App\Models\Round;
use App\Models\RoundStudent;

class MyLearningController extends Controller
{
    public function getUserActivePaidRoundIds($course)
    {
        if (!auth()->check()) {
            return collect();
        }

        $user = auth()->user();
        $roundIds = Round::where('course_id', $course->id)->where('status', DefineStatus::ACTIVE->value)
            // ->where('start_date', '<=', now())
            ->where('end_date', '>=', now())
            ->pluck('id');

            // dd($roundIds);


        return RoundStudent::where('user_id', $user->id)
            ->whereIn('round_id', $roundIds)
            ->where('status', DefineStatus::ACTIVE->value)
            ->where('payment_status', PaymentStatus::PAID->value)
            ->pluck('round_id');
    }
    public function show(Course $course){
        $userId=auth()->user();
        //check if the course is enrolled
        $isEnrolled = CourseEnrollment::where("user_id",$userId->id)
        ->where("course_id",$course->id)
        ->where("payment_status",1)
        ->where("status",1)
        ->exists();
        if(!$isEnrolled){
            return $this->apiResponse([],__("main.not_enrolled_to_this_course"),400);
        }

        $enrolledRoundIds = $this->getUserActivePaidRoundIds($course);

        if ($enrolledRoundIds->isEmpty()) {
            return $this->apiResponse([], __('main.the_round_hasended'));
        }


        $course->load([
            'category',
            'rounds' => function ($query) use ($enrolledRoundIds) {
                $query->whereIn('id', $enrolledRoundIds)
                    ->with('lectures.attachments');
            },
        ]);

        return $this->apiResponseShow(
            new CourseResource($course)
        );
    }
}
