<?php

namespace App\Http\Controllers\Api\V1\ClientSide\Notification;

use App\Http\Controllers\Controller;
use App\Services\Notification\NotificationService;
use App\Http\Resources\Notification\NotificationResource;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function __construct(protected NotificationService $notificationService)
    {
        $this->notificationService = $notificationService;
    }
    public function getUnReadNotificationCount()
    {
        $count = $this->notificationService->getUnReadNotificationCount();
        return $this->apiResponseShow(['count' => $count]);
    }
    public function latestUserNotifications()
    {
        $notifications = $this->notificationService->getLatestNotifications();
        return $this->apiResponseShow(NotificationResource::collection($notifications));
    }
    public function allUserNotifications()
    {
        $notifications = $this->notificationService->getAllUserNotifications();
        return $this->apiResponseShow(NotificationResource::collection($notifications));
    }
    public function getReadNotifications()
    {
        $notifications = auth()->user()->notifications()
            ->whereNotNull('read_at')
            ->latest()
            ->dynamicPaginate();

        return NotificationResource::collection($notifications);
    }

    public function getUnreadNotifications()
    {
        $notifications = auth()->user()->notifications()
            // ->whereNull('read_at')
            ->latest()
            ->dynamicPaginate();

        return NotificationResource::collection($notifications);
    }
    public function readMarkNotification(Request $request)
    {
        if ($request->filled('notification_id')) {
            $notification = auth()->user()->notifications()->find($request->notification_id);

            if ($notification && $notification->read_at === null) {
                $notification->markAsRead();
            }

            return $this->apiResponseShow([]);
        }

        auth()->user()->unreadNotifications->each->markAsRead();

        return $this->apiResponseShow([]);
    }
}
