<?php

namespace App\Http\Controllers\Api\V1\ClientSide;

use App\Http\Controllers\Controller;
use App\Models\Evaluation;
use App\Models\Lecture;
use Illuminate\Http\Request;

class ScannerController extends Controller
{
    public function stats(){
        $user = auth()->user();
        $evaluations = $user->evaluations;

        $enrolledRounds = $user->enrolledRounds()->with(['lectures.evaluations' => function($query) use ($user) {
            $query->where('user_id', $user->id);
        }])->get();

        $attendanceStats = [];
        $totalAttended = 0;
        $totalLectures = 0;

        foreach ($enrolledRounds as $round) {
            $roundLectures = $round->lectures;
            $attendedCount = 0;
            $lectureCount = $roundLectures->count();

            $lectureDetails = [];
            foreach ($roundLectures as $lecture) {
                $evaluation = $lecture->evaluations->first();
                $isAttended = $evaluation ? $evaluation->is_attend : false;

                if ($isAttended) {
                    $attendedCount++;
                }

                $lectureDetails[] = [
                    'lecture_id' => $lecture->id,
                    'lecture_name' => $lecture->name,
                    'start_time' => $lecture->start_time,
                    'week_number' => $lecture->week_number,
                    'is_attended' => $isAttended,
                ];
            }

            $totalAttended += $attendedCount;
            $totalLectures += $lectureCount;

            $attendanceStats[] = [
                'round_id' => $round->id,
                'round_name' => $round->name,
                'course_name' => $round->course->name ?? null,
                'attended_lectures' => $attendedCount,
                'total_lectures' => $lectureCount,
                'attendance_percentage' => $lectureCount > 0 ? round(($attendedCount / $lectureCount) * 100, 2) : 0,
                'lectures' => $lectureDetails,
            ];
        }

        return $this->apiResponse([
            'overall_stats' => [
                'total_attended_lectures' => $totalAttended,
                'total_lectures' => $totalLectures,
                'overall_attendance_percentage' => $totalLectures > 0 ? round(($totalAttended / $totalLectures) * 100, 2) : 0,
            ],
            'rounds_attendance' => $attendanceStats,
            'message' => "You attended {$totalAttended} lectures out of {$totalLectures} lectures"
        ]);
    }
    public function scan(Request $request){
        $request->validate([
            'lecture_id'=>'required|exists:lectures,id',
        ]);
        $user=auth()->user();

        $lecture = Lecture::find($request->lecture_id);
        $isEnrolled = $user->enrolledRounds()
            ->where('round_id', $lecture->round_id)
            ->exists();

        if (!$isEnrolled) {
            return $this->apiResponseFailed('You are not enrolled in this lecture');
        }
        Evaluation::firstOrCreate(
            ['lecture_id'=>$request->lecture_id,'user_id'=>$user->id],
            [
                'is_attend'=>true,
            ]
        );
        return $this->apiResponse('Attendance has been recorded successfully');
    }
}
