<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\ContactUs\ContactUsResource;
use App\Models\ContactUs;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class ContactUsController extends Controller
{
    public function __construct()
    {
        //
    }

    public function index(): AnonymousResourceCollection
    {
        $contactUs = ContactUs::useFilters()
            ->latest()
            ->with('user')
            ->dynamicPaginate();
        return ContactUsResource::collection($contactUs);
    }


    public function show($contactUs): JsonResponse
    {
        $contactUs = ContactUs::findOrFail($contactUs);
        $contactUs->load('user');
        $contactUs->update(['status' => 'read']);
        return $this->apiResponseStored(new ContactUsResource($contactUs));
    }
}
