<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\Coupon\UpdateCouponRequest;
use App\Http\Requests\Coupon\CreateCouponRequest;
use App\Http\Resources\Coupon\CouponResource;
use App\Models\Coupon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class CouponController extends Controller
{
    public function __construct()
    {
        //
    }

    public function index(): AnonymousResourceCollection
    {
        $coupons = Coupon::useFilters()->dynamicPaginate();

        return CouponResource::collection($coupons);
    }

    public function store(CreateCouponRequest $request): JsonResponse
    {
        $coupon = Coupon::create($request->validated());

        return $this->apiResponseStored(new CouponResource($coupon));
    }

    public function show(Coupon $coupon): JsonResponse
    {
        return $this->apiResponseShow(new CouponResource($coupon));
    }

    public function update(UpdateCouponRequest $request, Coupon $coupon): JsonResponse
    {
        $coupon->update($request->validated());

        return $this->apiResponseUpdated(new CouponResource($coupon));
    }

    public function destroy(Coupon $coupon): JsonResponse
    {
        $coupon->delete();
        return $this->apiResponseDeleted();
    }

}
