<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\ExpenseCategory;
use Illuminate\Http\Request;

class ExpenseCategoryController extends Controller
{
    public function index()
    {
        $categories = ExpenseCategory::all();
        return $this->apiResponse($categories);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255|unique:expense_categories,title',
        ]);
        $expenseCategory = ExpenseCategory::create($data);
        return $this->apiResponseStored($expenseCategory);
    }

    public function show(ExpenseCategory $expenseCategory)
    {
        return $this->apiResponseShow($expenseCategory);
    }

    public function update(Request $request, ExpenseCategory $expenseCategory)
    {
        $data = $request->validate([
            'title' => 'required|string|max:255|unique:expense_categories,title',
        ]);
        $expenseCategory->update($data);
        return $this->apiResponseUpdated($expenseCategory);
    }

    public function destroy(ExpenseCategory $expenseCategory)
    {
        $expenseCategory->delete();
        return $this->apiResponseDeleted();
    }
}
