<?php

namespace App\Http\Controllers\Api\V1\Instructor;

use App\Enums\DefineStatus;
use App\Http\Controllers\Controller;
use App\Http\Resources\Lecture\LectureResource;
use App\Models\Lecture;
use App\Models\Round;

class InstructorMeetingController extends Controller
{
    public function instructorUpcomingMeetings()
    {
        $instructor = auth()->user();
        $today = now()->toDateString();
        $nextWeek = now()->addDays(7)->toDateString();

        $roundIds = Round::where('instructor_id', $instructor->id)
            ->where('status', DefineStatus::ACTIVE)
            ->pluck('id');

        $lectures = Lecture::query()
            ->select('lectures.*')
            ->from('lectures')
            ->join('zoom_meetings', 'lectures.id', '=', 'zoom_meetings.lecture_id')
            ->whereIn('lectures.round_id', $roundIds)
            ->whereBetween('zoom_meetings.start_time', [$today, $nextWeek])
            ->active()
            ->with([
                'round:id,name',
                'zoomMeetings' => function ($query) use ($today, $nextWeek) {
                    $query->whereBetween('start_time', [$today, $nextWeek]);
                },
                'lectureVideos'
            ])
            ->get();

        return LectureResource::collection($lectures);
    }
}
