<?php

namespace App\Http\Controllers\Api\V1\Instructor;

use App\Http\Controllers\Controller;
use App\Http\Resources\Payout\PayoutResource;
use App\Models\Payout;

class InstructorPaymentController extends Controller
{
    public function allReceivedPayments()
    {
        $instructor = auth()->user();

        $payouts = Payout::query()
            ->where('user_id', $instructor->id)
            ->with('admin:id,name', 'instructor:id,name,email,phone')
            ->useFilters()
            ->latest()
            ->dynamicPaginate(50);

        return PayoutResource::collection($payouts);
    }

}
