<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\Grade\GradeRequest;
use App\Http\Resources\GradeLecture\GradeLectureResource;
use App\Models\StudentAnswer;
use App\Models\StudentGrade;
use Illuminate\Http\Request;

class LectureGradeController extends Controller
{
    public function index($lecture){
        $grades=StudentGrade::where('lecture_id',$lecture)->latest()
        ->useFilters()
        ->dynamicPaginate();
        return GradeLectureResource::collection($grades->load('student','lecture'));
    }
    public function store(GradeRequest $request)
    {
        $validated = $request->validated();

        $exists = StudentGrade::where([
            'student_id' => $validated['student_id'],
            'lecture_id' => $validated['lecture_id']
        ])->exists();

        if ($exists) {
            return $this->apiResponseFailed(
                'Grade already exists for this student and lecture');
        }


        StudentGrade::create([
            'student_id' => $validated['student_id'],
            'lecture_id' => $validated['lecture_id'],
            'total_questions' => $validated['total_questions'],
            'correct_answers' => $validated['correct_answers'],
            'grade' => $validated['grade'],
        ]);

        return $this->apiResponseStored([]);
    }

    public function update(GradeRequest $request,StudentGrade $grade)
    {
        $validated = $request->validated();

        $grade->update([
            'student_id' => $validated['student_id'],
            'lecture_id' => $validated['lecture_id'],
            'total_questions' => $validated['total_questions'],
            'correct_answers' => $validated['correct_answers'],
            'grade' => $validated['grade'],
        ]);

        return $this->apiResponseUpdated([]);
    }

    public function show(StudentGrade $grade){
        return $this->apiResponseShow(new GradeLectureResource($grade));
    }

    public function destroy(StudentGrade $grade){
        $grade->delete();
        return $this->apiResponseDeleted();
    }
}
