<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\Lecture\lectureVideosResource;
use App\Models\LectureVideo;
use Illuminate\Http\Request;

class LectureVideoController extends Controller
{
    public function store(Request $request){
        $data=$request->validate([
            'lectures_array'=>'required|array',
            'lectures_array.*.url'=>'required|string|max:255',
            'lectures_array.*.title'=>'nullable|string|max:255',
            'lectures_array.*.id'=>'nullable|string|max:255',
            'lecture_id'=>'required|integer|exists:lectures,id',
        ]);

        $lecturesIds = collect($data['lectures_array'])
            ->pluck('id')
            ->filter()
            ->all();
        LectureVideo::where('lecture_id', $data['lecture_id'])
        ->whereNotIn('id', $lecturesIds)
        ->delete();

        foreach($data['lectures_array'] as $lectureVideo){
            $payload=[
                'url' => $lectureVideo['url'],
                'title' => $lectureVideo['title']??'',
            ];
            if(empty($lectureVideo['id'])){
                $lectureVideo=LectureVideo::create($payload+[
                    'lecture_id' => $data['lecture_id']
                ]);
            }else{
                $lectureVideo=LectureVideo::find($lectureVideo['id']);
                $lectureVideo->fill($payload);
                $lectureVideo->save();
            }
        }
        return $this->apiResponseStored(new lectureVideosResource($lectureVideo));
    }
    public function  update(Request $request,LectureVideo $lectureVideo) {
        $data=$request->validate([
            'url'=>'required|string|max:255',
            'title'=>'nullable|string|max:255',
            'lecture_id'=>'required|exists:lectures,id',
        ]);
        $lectureVideo->update($data);
        return $this->apiResponseUpdated(new lectureVideosResource($lectureVideo));
    }

    public function destroy(LectureVideo $lectureVideo){
        $lectureVideo->delete();
        return $this->apiResponseDeleted();
    }
}
