<?php


namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\PaymentMethod\PaymentMethodResources;
use App\Models\Payment;
use App\Models\PaymentMethod;
use Illuminate\Http\Request;

class PaymentMethodController extends Controller
{
    public function index()
    {
        return PaymentMethodResources::collection(
            PaymentMethod::with([
                'transactions.user',
                'transactions.courseEnrollment.round.course',
                'transactions.installment',
                'transactions.acceptedBy'
            ])->get()
        );
    }
    public function store(Request $request)
    {
        $data=$request->validate([
            'name' => 'required|string|max:255|unique:payment_methods,name',
        ]);
        $paymentMethod=PaymentMethod::create($data);
        return $this->apiResponseStored(new PaymentMethodResources(
            $paymentMethod->load('transactions')
        ));
    }
    public function show(PaymentMethod $paymentMethod)
    {
        return $this->apiResponseShow(
            new PaymentMethodResources(
                $paymentMethod->load('transactions')
            )
        );
    }
    public function update(Request $request, PaymentMethod $paymentMethod)
    {
        $data=$request->validate([
            'name' => 'required|string|max:255|unique:payment_methods,name',
        ]);
        $paymentMethod->update($data);
        return $this->apiResponseUpdated(
            new PaymentMethodResources($paymentMethod->load('transactions'))
        );
    }
    public function destroy(PaymentMethod $paymentMethod)
    {
        $paymentMethod->delete();
        return $this->apiResponseDeleted([
            'message' => 'Payment method deleted successfully',
        ]);
    }
}
