<?php

namespace App\Http\Controllers\Api\V1;

use App\Enums\QuestionType;
use App\Http\Controllers\Controller;
use App\Http\Requests\PlacementTest\StorePlacementTestRequest;
use App\Http\Requests\PlacementTest\UpdatePlacementTestRequest;
use App\Http\Resources\PlacementTest\PlacementTestResultResource;
use App\Http\Resources\PlacementTest\QuestionResource;
use App\Http\Traits\ApiResponse;
use App\Http\Traits\MediaHandler;
use App\Models\PlacementTestResult;
use App\Models\Question;
use Illuminate\Http\Request;

class PlacementTestController extends Controller
{
    use ApiResponse, MediaHandler;
    public function index(){
        $questions = Question::with('category','options','tag')->useFilters()->dynamicPaginate();
        return QuestionResource::collection($questions);
    }

    public function store(StorePlacementTestRequest $request){
        $data = $request->validated();

        if($data['question_type'] == QuestionType::Listening->value){
            $data['listening_content'] = $this->upload($data['listening_content'],'placement-test');
        }

        $question = Question::create($data);
        $question->options()->createMany($data['options']);
        $question->load('category','options','tag');

        return $this->apiResponseStored(new QuestionResource($question));
    }

    public function show(Question $placement_test){
        $placement_test->load('category','options','tag');
        return $this->apiResponse(new QuestionResource($placement_test));
    }

    public function update(UpdatePlacementTestRequest $request, Question $placement_test){
        $data = $request->validated();

        if($data['question_type'] == QuestionType::Listening->value){
            $data['listening_content'] = $this->updateMedia($data['listening_content'],'placement-test',$placement_test->listening_content);
        }

        // dd($data['options']);

        $placement_test->update($data);
        // $placement_test->options()->delete();
        // $placement_test->options()->createMany($data['options']);
        if(isset($data['options'])){
            foreach ($data['options'] as $optionData) {
                if (isset($optionData['id'])) {
                    $placement_test->options()->where('id', $optionData['id'])->update([
                        'option_content' => $optionData['option_content'],
                        'is_correct'     => $optionData['is_correct']
                    ]);
                } else {
                    $placement_test->options()->create($optionData);
                }
            }
        }
        $placement_test->load('category','options','tag');

        return $this->apiResponseUpdated(new QuestionResource($placement_test));
    }

    public function destroy(Question $placement_test){
        $placement_test->delete();
        return $this->apiResponseDeleted();
    }

    public function results(){
        $placement_test_result=PlacementTestResult::with('level','user')->useFilters()->dynamicPaginate();
        return PlacementTestResultResource::collection($placement_test_result);
    }

}
