<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\PlacementTestTag;
use Illuminate\Http\Request;

class PlacmentTestTagController extends Controller
{
    public function index(){
        return $this->apiResponse(PlacementTestTag::all());
    }
    public function store(Request $request){
        $data=$request->validate([
            'name'=>'required|string|max:150',
        ]);
        $placementTestTag=PlacementTestTag::create($data);
        return $this->apiResponseStored($placementTestTag);
    }
    public function update(Request $request,PlacementTestTag $placementTestTag){
        $data=$request->validate([
            'name'=>'required|string|max:150',
        ]);
        $placementTestTag->update($data);
        return $this->apiResponseUpdated($placementTestTag);
    }

    public function destroy(PlacementTestTag $placementTestTag){
        $placementTestTag->delete();
        return $this->apiResponseDeleted();
    }
}
