<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\Review\ReviewResource;
use App\Http\Traits\ApiResponse;
use App\Models\Review;

class ReviewController extends Controller
{
    use ApiResponse;

    public function index(){
        $reviews=Review::with('lecture','user')->dynamicPaginate();
        return ReviewResource::collection($reviews);
    }
    public function show($id){
        $reviews=Review::where('lecture_id',$id)->with('lecture','user')->dynamicPaginate();
        return ReviewResource::collection($reviews);
    }
    public function destroy(Review $review){
        $review->delete();
        return $this->apiResponseDeleted();
    }

}
