<?php

namespace App\Http\Controllers\Api\V1;

use App\Services\WaSenderService;
use App\Http\Controllers\Controller;
use App\Services\Notification\NotificationService;
use App\Http\Requests\WhatsappCampaigns\CreateWhatsappCampaignsRequest;

class SendWhatsAppCampaignsController extends Controller
{
    public function __construct(protected NotificationService $notificationService, protected WaSenderService $waSenderService) {}

    public function store(CreateWhatsappCampaignsRequest $request)
    {
        $data = $request->validated();
        if ((isset($data['round_id']) || isset($data['course_id']))) {
            $data['notifiables'] = $this->notificationService->getNotifiablesByContext($data);
        }
        if ($data['notifiables']->count() > 0 && $data['notifiables']->count() <= 5) {
            foreach ($data['notifiables'] as $notifiable) {
                $phone=$this->checkPhone($notifiable->phone);
                $message=$this->replaceVariables($data['message'], $notifiable);
                if($phone){
                    $this->waSenderService->sendMessage($phone, $message);
                }
            }
            return $this->apiResponseShow([],'Whatsapp Campaigns Sent Successfully',201);
        }
        return $this->apiResponseShow([],'Whatsapp Campaigns Not Sent',400);
    }

    public function checkPhone($phone)
    {
        $originalPhone = $phone;
        $phone = preg_replace('/\D/', '', $phone);

        if (strpos($phone, '0020') === 0) {
            $phone = substr($phone, 4);
        } elseif (strpos($phone, '20') === 0) {
            $phone = substr($phone, 2);
        } elseif (strpos($phone, '0') === 0) {
            $phone = substr($phone, 1);
        }

        if (preg_match('/^(10|11|12|15)\d{8}$/', $phone)) {
            return '+20' . $phone;
        }

        return $originalPhone;
    }


    public function replaceVariables($message, $user)
    {
        $replacements = [
            '{{name}}' => $user->name ?? '',
            '{{email}}' => $user->email ?? '',
            '{{phone}}' => $user->phone ?? '',
            '{{gender}}' => ($user->gender ?? 'male') != 'male' ? 'ة' : '',
        ];

        return str_replace(array_keys($replacements), array_values($replacements), $message);
    }


}
