<?php

namespace App\Http\Controllers\Api\V1;

use App\Models\Setting;
use App\Http\Traits\MediaHandler;
use Illuminate\Http\JsonResponse;
use App\Http\Controllers\Controller;
use App\Http\Resources\Setting\SettingResource;
use App\Http\Requests\Setting\UpdateSettingRequest;
use App\Http\Traits\ApiResponse;

class SettingController extends Controller
{
    use MediaHandler, ApiResponse;

    public function showSettings()
    {
        $settings = Setting::get();
        return $this->apiResponseShow($settings);
    }

    public function showSettingsApi()
    {
        $settings = Setting::get(['id', 'key', 'value', 'category', 'type'])
        ->groupBy('category');
        return $this->apiResponseShow($settings);
    }
    public function updateSettings(UpdateSettingRequest $request): JsonResponse
    {
        $data = $request->validated();
        foreach ($data as $key => $value) {
            $setting = Setting::where('key', $key)->first();
            if (!$setting) continue;
            // Handle image upload
            $value = $request->hasFile($key)
                ? MediaHandler::updateMedia($request->file($key), 'settings', $setting->value_path)
                : $value;
            // Update the setting with the new value
            $setting->update(['value' => $value]);
        }
        $settings = Setting::get(['id', 'key', 'value', 'category', 'type'])->groupBy('category');
        return $this->apiResponseUpdated(['settings' => $settings]);
    }
}
