<?php

namespace App\Http\Controllers\Api\V1\Student;

use App\Http\Controllers\Controller;
use App\Models\ProfileLink;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class ProfileLinkController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $profileLink = $user->profileLink;

        return $this->apiResponse($profileLink);
    }

    public function store(Request $request)
    {
        $user = Auth::user();

        $validator = Validator::make($request->all(), [
            'github' => ['nullable', 'url', 'max:255'],
            'linkedin' => ['nullable', 'url', 'max:255'],
            'behance' => ['nullable', 'url', 'max:255'],
            'facebook' => ['nullable', 'url', 'max:255'],
            'youtube' => ['nullable', 'url', 'max:255'],
            'stackoverflow' => ['nullable', 'url', 'max:255'],
            'devto' => ['nullable', 'url', 'max:255'],
        ]);

        if ($validator->fails()) {
            return $this->apiResponseFailed($validator->errors());
        }

        $profileLink = $user->profileLink()->updateOrCreate(
            ['user_id' => $user->id],
            $request->only([
                'github', 'linkedin', 'behance',
                'facebook', 'youtube', 'stackoverflow', 'devto'
            ])
        );

        return $this->apiResponseStored($profileLink);
    }
}
