<?php

namespace App\Http\Controllers\Api\V1\Student;

use App\Enums\DefineStatus;
use App\Http\Controllers\Controller;
use App\Http\Resources\Lecture\LectureResource;
use App\Models\Lecture;

class StudentMeetingController extends Controller
{
    /**
     * Get upcoming meetings for the authenticated student.
     * Categorizes meetings into today's meetings and meetings within the current month.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function upcomingMeetings()
    {
        $user     = auth()->user();
        $roundIds = $user->enrolledRounds()
            ->wherePivot('status', DefineStatus::ACTIVE)
            ->pluck('rounds.id');

        $lectures = Lecture::active()
            ->with(['zoomMeetings', 'evaluations', 'taskSubmissions',
            'lectureTasks',
            'studentEvaluation',
            'studentTaskSubmission','round','lectureVideos'])
            ->whereIn('round_id', $roundIds)
            ->orderByDesc('created_at')
            ->dynamicPaginate(50);

        return LectureResource::collection($lectures);
    }

    public function todaysMeetings()
    {
        $user = auth()->user();
        $roundIds = $user->enrolledRounds()
            ->wherePivot('status', DefineStatus::ACTIVE)
            ->pluck('rounds.id');
        $today = now()->toDateString();

        $lectures = Lecture::query()
            ->select('lectures.*')
            ->from('lectures')
            // ->join('zoom_meetings', 'lectures.id', '=', 'zoom_meetings.lecture_id')
            ->whereIn('lectures.round_id', $roundIds)
            ->whereDate('lectures.start_time', $today)
            // ->whereDate('zoom_meetings.start_time', $today)
            ->active()
            ->with(['zoomMeetings' => function ($query) use ($today) {
                    $query->whereDate('start_time', $today);
                },'evaluations', 'taskSubmissions',
            'lectureTasks',
            'studentEvaluation',
            'studentTaskSubmission','round'])
            ->dynamicPaginate(50);

        return LectureResource::collection($lectures);
    }

    // public function todaysMeetings()
    // {
    //     $user = auth()->user();
    //     $today = now()->toDateString();
    //     $roundIds = $user->enrolledRounds()->pluck('rounds.id'); // Fix ambiguity

    //     $lectures = Lecture::active()
    //         ->whereIn('round_id', $roundIds)
    //         ->whereHas('zoomMeetings', function ($query) use ($today) {
    //             $query->whereDate('start_time', $today);
    //         })
    //         ->with([
    //             'zoomMeetings' => function ($query) use ($today) {
    //                 $query->whereDate('start_time', $today);
    //             },
    //             'evaluations',
    //             'taskSubmissions'
    //         ])
    //         ->dynamicPaginate();

    //     return LectureResource::collection($lectures);
    // }
}
