<?php

namespace App\Http\Controllers\Api\V1\Student;

use App\Http\Controllers\Controller;
use App\Http\Resources\Installment\InstallmentResource;
use App\Http\Resources\Transaction\TransactionResource;
use App\Models\Installment;
use App\Models\Transaction;
use Illuminate\Http\JsonResponse;


class StudentTransactionController extends Controller
{
    /**
     * Get authenticated student's transactions.
     *
     * Retrieves transactions with related installments and enrollment details.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function showStudentTransactionsAndInstallments(): JsonResponse
    {
        $userId = auth()->id();

        $transactions = Transaction::with([
            // 'installment',
            // 'paymentMethod',
            // 'acceptedBy',
            'courseEnrollment.round.course:id,title',
            'courseEnrollment.course:id,title',
            'user'
        ])
        ->whereHas('courseEnrollment', fn($query) => $query->where('user_id', $userId))
        ->get();

        $installments = Installment::with([
            // 'transactions',
            'courseEnrollment.round.course:id,title',
            'courseEnrollment.course:id,title',
            'user'
        ])
        ->whereHas('courseEnrollment', fn($query) => $query->where('user_id', $userId))
        ->get();

        return $this->apiResponseShow([
            'transactions' => TransactionResource::collection($transactions),
            'installments' => InstallmentResource::collection($installments),
        ]);
    }

}
