<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\Subject\SubjectResource;
use App\Models\Subject;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class SubjectController extends Controller
{
    public function index()
    {
        $subjects = Subject::latest()->dynamicPaginate();
        return SubjectResource::collection($subjects);
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $subject = Subject::create($data);

        return new SubjectResource($subject);
    }

    public function show(Subject $subject)
    {
        return new SubjectResource($subject->load('freeMaterial'));
    }

    public function update(Request $request, Subject $subject)
    {
        $data = $request->validate([
            'name' => 'sometimes|required|string|max:255',
            'description' => 'nullable|string',
        ]);

        $subject->update($data);

        return new SubjectResource($subject);
    }
    public function destroy(Subject $subject)
    {
        if ($subject->freeMaterial()->exists()) {
            return $this->apiResponseFailed(
                'Cannot delete subject with associated free materials',
            );
        }

        $subject->delete();

        return $this->apiResponseDeleted();
    }
}
