<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Requests\TicketMessage\UpdateTicketMessageRequest;
use App\Http\Requests\TicketMessage\CreateTicketMessageRequest;
use App\Http\Resources\TicketMessage\TicketMessageResource;
use App\Models\TicketMessage;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class TicketMessageController extends Controller
{
    public function __construct()
    {

    }

    public function index(): AnonymousResourceCollection
    {
        $ticketMessages = TicketMessage::useFilters()->dynamicPaginate();

        return TicketMessageResource::collection($ticketMessages);
    }

    public function store(CreateTicketMessageRequest $request): JsonResponse
    {
        $ticketMessage = TicketMessage::create($request->validated());

        return $this->responseCreated('TicketMessage created successfully', new TicketMessageResource($ticketMessage));
    }

    public function show(TicketMessage $ticketMessage): JsonResponse
    {
        return $this->responseSuccess(null, new TicketMessageResource($ticketMessage));
    }

    public function update(UpdateTicketMessageRequest $request, TicketMessage $ticketMessage): JsonResponse
    {
        $ticketMessage->update($request->validated());

        return $this->responseSuccess('TicketMessage updated Successfully', new TicketMessageResource($ticketMessage));
    }

    public function destroy(TicketMessage $ticketMessage): JsonResponse
    {
        $ticketMessage->delete();

        return $this->responseDeleted();
    }

   
}
