<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\Topic\TopicResource;
use App\Http\Traits\ApiResponse;
use App\Models\Topic;
use Illuminate\Http\Request;

class TopicController extends Controller
{
    use ApiResponse;
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return $this->apiResponse(Topic::with('courses')->orderBy('order')->get());
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data=$request->validate([
            'name' => 'required|string|max:255',
            'order' => 'nullable|integer|min:1',
        ]);
        $topic = Topic::create($data);
        return $this->apiResponseStored(new TopicResource($topic->load('courses')));
    }

    /**
     * Display the specified resource.
     */
    public function show(Topic $topic)
    {
        return $this->apiResponseShow(new TopicResource($topic->load('courses')));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Topic $topic)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Topic $topic)
    {
        $data=$request->validate([
            'name' => 'required|string|max:255',
            'order' => 'nullable|integer|min:1',
        ]);
        $topic->update($data);
        return $this->apiResponseUpdated(new TopicResource($topic->load('courses')));
    }


    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Topic $topic)
    {
        $topic->loadMissing('courses');
        if ($topic->courses->isNotEmpty()) {
            return $this->apiResponseFailed('Cannot delete topic with courses');
        }
        $topic->delete();
        return $this->apiResponseDeleted();
    }
}
