<?php

namespace App\Http\Controllers;

use App\Imports\ImportLecture;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as ValidatorFacade;
use Maatwebsite\Excel\Facades\Excel;

class ImportLectureController extends Controller
{
    public function showImportForm()
    {
        return view('import.lectures');
    }

    public function import(Request $request)
    {
        $validator = ValidatorFacade::make($request->all(), [
            'file' => 'required|file|mimetypes:application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,text/csv,text/plain'
        ], [
            'file.mimetypes' => 'The file must be a file of type: xlsx, xls, csv.'
        ]);

        if ($validator->fails()) {
            return response()->json([
                'message' => 'Wrong entered data!',
                'data' => [
                    'file' => $validator->errors()->first('file')
                ],
                'status' => false,
                'code' => 422
            ], 422);
        }

        try {
            $import = new ImportLecture();
            Excel::import($import, $request->file('file'));

            $errors = $import->getErrors();

            if (!empty($errors)) {
                return response()->json([
                    'message' => 'Some errors occurred during import.',
                    'data' => ['errors' => $errors],
                    'status' => false,
                    'code' => 422
                ], 422);
            }

            return response()->json([
                'message' => 'Lectures imported successfully!',
                'data' => [],
                'status' => true,
                'code' => 200
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Error processing file: ' . $e->getMessage(),
                'data' => [],
                'status' => false,
                'code' => 500
            ], 500);
        }
    }
}
