<?php

namespace App\Http\Middleware;

use App\Http\Traits\ApiResponse;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsStudentMiddleware
{
    use ApiResponse;

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = $request->user();

        if ($user) {
            $user->update([
                'is_open'=>true,
                'last_activity'=>now(),
                'last_logout_at'=>null
            ]);
        }

        if (!$user || !$request->user()->tokenCan('type:student')) {
            return $this->apiResponse([],__('http-statuses.403'),403);
        }

        return $next($request);
    }
}
