<?php

namespace App\Http\Requests\Category;

use App\Enums\DefineStatus;
use Illuminate\Validation\Rule;
use App\Http\Requests\FormRequest;

class UpdateCategoryRequest extends FormRequest
{
    public function rules(): array
    {
        $categoryId = $this->route('category');

        return [
            'name' => ['required', 'string', 'max:255', Rule::unique('categories', 'name')->ignore($categoryId)],
            'status' => ['required', 'integer', Rule::in(DefineStatus::values())],
            'order' => ['nullable', 'integer'],
        ];
    }
}
