<?php

namespace App\Http\Requests\Coupon;

use Illuminate\Foundation\Http\FormRequest;

class CreateCouponRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'code'                => ['required', 'string', 'max:255', 'unique:coupons'],
            'type'=>['required','integer','in:'.implode(',', \App\Enums\TypeCoupon::values())],
            'discount_percentage' => ['required', 'integer'],
            'max_uses'            => ['required', 'integer', 'min:1'],
            'start_date'          => ['required', 'date'],
            'end_date'            => ['required', 'date', 'after:start_date'],
            'status'              => ['required', 'boolean'],
        ];
    }
}
