<?php

namespace App\Http\Requests\Evaluation;

use App\Http\Requests\FormRequest;

class CreateEvaluationRequest extends FormRequest
{
    public function rules(): array
    {
        return [
            'evaluation_id'     => ['required', 'exists:evaluations,id'],
            'task_degree'       => ['required', 'numeric', 'between:0,100'],
            'assignment_degree' => ['required', 'numeric', 'between:0,100'],
        ];
    }
}
