<?php

namespace App\Http\Requests\Evaluation;

use App\Enums\UserType;
use App\Models\User;
use App\Http\Requests\FormRequest;

class StudentAttendanceRequest extends FormRequest
{
    // public function rules(): array
    // {
    //     return [
    //         'student_ids' => [
    //             'required',
    //             'array',
    //             function ($attribute, $value, $fail) {
    //                 $validIds = User::whereIn('id', $value)->pluck('id');
    //                 $invalidIds = collect($value)->diff($validIds);
    //                 if ($invalidIds->isNotEmpty()) {
    //                     $fail('The following students are invalid: ' . $invalidIds->implode(', '));
    //                 }
    //             },
    //         ],
    //         'student_ids.*' => ['distinct'],
    //     ];
    // }

    public function rules(): array
    {
        return [
            'student_ids' => [
                'required',
                'array',
                function ($attribute, $value, $fail) {
                    // Ensure all student IDs exist in the database and are of type STUDENT
                    $validIds = User::whereIn('id', $value)
                        ->where('type', UserType::STUDENT->value)
                        ->pluck('id');
                    
                    // Get any invalid IDs
                    $invalidIds = collect($value)->diff($validIds);
                    
                    if ($invalidIds->isNotEmpty()) {
                        $fail('The following students are invalid: ' . $invalidIds->implode(', '));
                    }
                },
            ],
            'student_ids.*' => ['distinct'], // Ensure no duplicate student IDs
        ];
    }
}



