<?php

namespace App\Http\Requests\Installment;

// use Illuminate\Foundation\Http\FormRequest;

use App\Enums\PaymentStatus;
use App\Http\Requests\FormRequest;
use App\Models\Enrollment;
use App\Models\Installment;
use Carbon\Carbon;
use Illuminate\Validation\Rule;
use Illuminate\Validation\ValidationException;
use Illuminate\Validation\Validator;

class CreateInstallmentRequest extends FormRequest
{

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'enrollment_id' => ['required', 'exists:enrollments,id'],
            'installment_amount' => ['required', 'numeric', 'min:0.01'],
            'due_date' => ['required', 'date', 'after_or_equal:' . now()->format('d-m-Y')],
            'payment_status' => ['required', 'integer', Rule::in(PaymentStatus::values())],
        ];
    }
}
